/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEACLD;
import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAColorimetryDataBlock
extends DataBlock {
    private ArrayList<CEACLD> aCLDs = new ArrayList();
    private static final int maxNumDescriptors = 1;
    private static final int descriptorSize = 3;
    private static final int iColorimetryTag = 7;

    public CEAColorimetryDataBlock() {
        super(3);
        this.iDataBlockTagCode = 7;
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.COLORIMETRY_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        if (string.length() > 8) {
            return "Colorimetry Data Block is too big.";
        }
        super.setHeader(string.substring(0, 2));
        if (Integer.parseInt(string.substring(2, 4), 16) != 5) {
            string2 = "Error parsing Colorimetry Data Block";
        } else {
            CEACLD cEACLD = new CEACLD();
            cEACLD.uploadDescriptorData(string.substring(2, 8));
            this.aCLDs.add(cEACLD);
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        String string = new String();
        if (this.aCLDs == null) {
            this.adjustNumDescriptors(1);
            string = string.concat(super.getHeader());
            string = string.concat("05000");
        } else if (this.aCLDs.size() == 0) {
            this.adjustNumDescriptors(1);
            string = string.concat(super.getHeader());
            string = string.concat("05000");
        } else {
            string = string.concat(super.getHeader());
            for (int i = 0; i < this.getCurrentNumDescriptors(); ++i) {
                string = string.concat(this.aCLDs.get(i).extractDescriptorData());
            }
        }
        return string;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aCLDs.remove(n);
    }

    @Override
    public void removeAllDescriptors() {
        this.aCLDs.clear();
        this.adjustNumDescriptors(-1);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        if (this.aCLDs == null) {
            this.aCLDs = new ArrayList(1);
        }
        if (this.aCLDs.size() == 1) {
            bl = false;
        } else {
            this.aCLDs.add((CEACLD)cEADescriptor);
            this.adjustNumDescriptors(1);
            bl = true;
        }
        return bl;
    }

    public ArrayList<CEACLD> getDescriptors() {
        return this.aCLDs;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }

    public void clearDescriptors() {
        this.aCLDs.clear();
        this.aCLDs = null;
        this.adjustNumDescriptors(0);
    }

    @Override
    public boolean isJustOneCopyAllowed() {
        return true;
    }
}

